#---------------------------------------------------------------------------
# Copyright 2012 The Open Source Electronic Health Record Agent
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#---------------------------------------------------------------------------

import sys
from OSEHRAHelper import PROMPT

#---------------------------------------------------------------------
# Ensure that the null device is correctly configured.
#---------------------------------------------------------------------

def InitializeDevice(VistA):
  VistA.wait(PROMPT)
  VistA.write('S DUZ=1 D Q^DI')
  VistA.wait('Select OPTION:')
  VistA.write('1')
  VistA.wait('INPUT TO WHAT FILE')
  VistA.write('DEVICE')
  VistA.wait('EDIT WHICH FIELD')
  VistA.write('$I\rSIGN-ON/SYSTEM DEVICE\r')
  VistA.wait('NAME:')
  VistA.write('NULL\r1')
  VistA.wait('//')
  if sys.platform=='win32':
    VistA.write('//./nul\rNO\r')
  else:
    VistA.write('/dev/null\rNO\r')
  VistA.wait('Select OPTION')
  VistA.write('')
